<?php if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/**
 * @var string $id
 * @var array $option
 * @var array $data
 * @var string $sortable_image url
 */
$attr = $option['attr'];
unset($attr['name']);
unset($attr['value']);

if ($option['sortable']) {
	$attr['class'] .= ' is-sortable';
}

// must contain characters that will remain the same after htmlspecialchars()
$increment_placeholder = '###-addable-popup-increment-'. slz_rand_md5() .'-###';
?>
<div <?php echo slz_attr_to_html($attr); ?>>
	<!-- Fixes https://github.com/ThemeFuse/Unyson/issues/1278 -->
	<?php echo slz()->backend->option_type('hidden')->render($id, array('value' => '~'), array(
		'id_prefix' => $data['id_prefix'],
		'name_prefix' => $data['name_prefix'],
	)); ?>
	<div class="items-wrapper">
		<?php foreach ($data['value'] as $key => $value): ?>
			<div class="item">
				<div class="input-wrapper">
					<?php echo slz()->backend->option_type('hidden')->render('', array('value' => json_encode($value)), array(
						'id_prefix' => $data['id_prefix'] . $id . '-' . $key . '-',
						'name_prefix' => $data['name_prefix'] . '[' . $id . ']',
					));?>
				</div>
				<img src="<?php echo esc_attr($sortable_image); ?>" class="sort-item"/>

				<div class="content"><!-- will be populated from js --></div>
				<a href="#" class="dashicons slz-x delete-item"></a>
			</div>
		<?php endforeach; ?>
	</div>
	<div class="default-item">
		<div class="input-wrapper">
			<?php echo slz()->backend->option_type('hidden')->render('', array('value' => '[]'), array(
				'id_prefix' => $data['id_prefix'] . $id . '-' . $increment_placeholder,
				'name_prefix' => $data['name_prefix'] . '[' . $id . ']',
			)); ?>
		</div>
		<img src="<?php echo esc_attr($sortable_image); ?>" class="sort-item"/>

		<div class="content"></div>
		<a href="#" class="dashicons slz-x delete-item"></a>
	</div>
	<?php
	echo slz_html_tag('button', array(
		'type' => 'button',
		'class' => 'button add-new-item',
		'onclick' => 'return false;',
		'data-increment-placeholder' => $increment_placeholder,
	), slz_htmlspecialchars($option['add-button-text']));
	?>
</div>

