<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Forbidden' ); }

$css = $custom_css = $output_grid = '';
$class_col = !empty($data['column']) ? 'column-'.$data['column'] : 'column-3';
$style = !empty($data['style']) ? $data['style'] : 'option-1';

$model = new SLZ_Gallery();
$model->init( $data );

$data = $model->attributes;
$uniq_id = $data['uniq_id'];
if( !empty($data['tab_uniq_id']) ) {
	$uniq_id = $data['tab_uniq_id'];
}
$post_type = $data['post_type'];

$data['thumb_size'] = 'large';

$html_options = array();
$model->html_format = $model->set_default_options( $html_options );

// load more button
$btn_load_more = '';
if( !empty( $data['load_more_btn_text'] ) && $model->query->max_num_pages > 1) {
	$btn_load_more = '
			<div class="btn-loadmore-wrapper" data-block-class="'.esc_attr($uniq_id).'">
				<a href="javascript:void(0)" class="slz-btn btn-loadmore" data-number="'.esc_attr( $data['limit_post'] ).'">'.esc_html( $data['load_more_btn_text'] ).'</a>
			</div>';
}
$json_attrs = $data;
// json data
$json_attrs['paged'] = 2;
$params = array('uniq_id' => $uniq_id);
if( $model->query->have_posts() ) {
	while ( $model->query->have_posts() ) {
		$model->query->the_post();
		$model->loop_index();
		switch($post_type) {
			case 'slz-gallery':
				$output_grid .= slz_render_view( $instance->locate_path('/views/block-gallery.php'), array('model' => $model, 'data' => $data, 'params' => $params ));
				break;
			default:
				$output_grid .= slz_render_view( $instance->locate_path('/views/block-portfolio.php'), array('model' => $model, 'data' => $data, 'params' => $params ));
				break;
		}
	}
	$model->reset();
?>

<div class="gallery-grid <?php echo esc_attr($uniq_id) . esc_attr($data['tab_block_class']);?>" <?php echo esc_attr($data['tab_role'])?>>
	<div class="ajax-gallery slz-isotope-grid-2 <?php echo esc_attr( $class_col ) .' '.esc_attr($style) ?>">
		<?php echo $output_grid;?>
	</div>
	<?php echo $btn_load_more ?>
	<div class="ajax-loadmore">
		<div class="ajax-gallery-atts hide" data-item="<?php echo esc_attr($uniq_id)?>" data-json="<?php echo esc_attr( json_encode( $json_attrs ) )?>" ></div>
	</div>
</div>
<?php
}