<?php
/*
Template Name: Announcement
*/
get_header();
?>

<style>
    section.announcement-list {
        margin: 40px 0pc;
    }
    .announcement-title h2 {
        text-align: center;
        font-size: 32px;
        font-weight: 600;
        text-transform: capitalize;
        margin-bottom: 25px;
    }
    .block-title {
    font-weight: 600;
    font-size: 24px;
    }
    .announcement-time {
        padding: 15px 0px 0px;
    }
</style>

<section class="announcement-list">
    <div class="container">
        <div class="announcement-title">
            <h2 classe="title">Announcement</h2>
        </div>
        <div class="row">
            <?php
            $args = array(
                'post_type'     => 'announcement',
                'posts_per_page' => -1,
                'post_status' => 'publish',
            );
            $the_query = new WP_Query($args);
            while ($the_query->have_posts()) : $the_query->the_post();
                $thumbimg = get_the_post_thumbnail_url();
            ?>
            <div class="col-12 col-lg-4">
                <div class="announcement-card-image">
                    <a href="<?php the_permalink(); ?>" class="blog-img">
                        <img src="<?php echo $thumbimg; ?>" alt="<?php echo the_title(); ?>" width="100%" height="250px">
                    </a>
                    <div class="announcement-time">
                        <?php the_time('j F Y'); ?>
                    </div>
                    <div class="announcement-card-title">
                        <a href="<?php the_permalink(); ?>" class="text-black">
                            <h4 class="block-title"><?php echo the_title(); ?></h4>
                        </a>
                    </div>
                </div>
            </div>
    
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
    
        </div>
    </div>
</section>
<?php get_footer();?>