jQuery( function( $ ) {
  'use strict';
  var SLZ_lazyload = {};
  SLZ_lazyload.checkaa = function( $item ) {
    var compareWidthHeight = function( $el ) {
      var x = $el.height(),
          y = $el.width();
      return x / y;
    };
    var $container = $item,
        imgUrl = $container.attr( 'src' ),
        imgRatio = compareWidthHeight( $container ),
        frameRatio = compareWidthHeight( $container.parent() );

    if ( $item.closest( '.slz-block-item-01' ).hasClass( 'object-fit-img' ) ) {
      if ( imgRatio >= 1 ) {
        if ( frameRatio >= 1 ) {
          $container.parents( '.block-image' ).addClass( 'portrait' );
        }
        else {
          $container.parents( '.block-image' ).addClass( 'landscape' );
        }
      }
      else {
        if ( frameRatio >= 1 ) {
          $container.parents( '.block-image' ).addClass( 'portrait' );
        }
        else {
          $container.parents( '.block-image' ).addClass( 'landscape' );
        }
      }
    }
  };
  $( document ).ready( function() {
    $( 'img[data-lazyload]' ).lazy( {
      // your configuration goes here
      scrollDirection: 'vertical',
      effect: 'fadeIn',
      visibleOnly: true,
      onError: function( element ) {
        console.log( 'error loading ' + element.data( 'src' ) );
      },
      afterLoad: function( element ) {
        setTimeout( function() {
          SLZ_lazyload.checkaa( element );
        }, 1000 );
      },
    } );

  } );

} );