<?php if (!defined('SLZ')) die('Forbidden');

class SLZ_Option_Type_Icon extends SLZ_Option_Type
{
	/**
	 * Prevent enqueue same font style twice, in case it is used in multiple sets
	 * @var array
	 */
	private $enqueued_font_styles = array();

	public function get_type()
	{
		return 'icon';
	}

	/**
	 * @internal
	 */
	public function _get_backend_width_type()
	{
		return 'full';
	}

	/**
	 * @internal
	 * {@inheritdoc}
	 */
	protected function _enqueue_static($id, $option, $data)
	{
		wp_enqueue_style(
			'slz-option-type-'. $this->get_type() .'-backend',
			slz_get_framework_directory_uri('/includes/option-types/'. $this->get_type() .'/static/css/backend.css'),
			slz()->manifest->get_version()
		);

		wp_enqueue_script(
			'slz-option-type-'. $this->get_type() .'-backend',
			slz_get_framework_directory_uri('/includes/option-types/'. $this->get_type() .'/static/js/backend.js'),
			array('jquery', 'slz-events'),
			slz()->manifest->get_version()
		);

		$sets = $this->get_sets();

		if (isset($sets[ $option['set'] ])) {
			$set = $sets[ $option['set'] ];

			unset($sets);

			$font_style_sources = (array) $set['font-style-src'];

			foreach($font_style_sources as $key => $style_source) {

				/**
				 * user hash as array key instead of src, because src can be a very long data-url string
				 */
				$style_hash = md5($style_source);

				if (!isset($this->enqueued_font_styles[ $style_hash ])) {
					wp_enqueue_style(
						"slz-option-type-{$this->get_type()}-font-{$option['set']}-{$style_hash}",
						$style_source,
						array(),
						slz()->manifest->get_version()
					);

					$this->enqueued_font_styles[ $style_hash ] = true;
				}
			}
		}

		return true;
	}

	/**
	 * @internal
	 */
	protected function _render($id, $option, $data)
	{
		$sets = $this->get_sets();

		if (isset($sets[ $option['set'] ])) {
			$set = $sets[ $option['set'] ];
		} else {
			$set = $this->generate_unknown_set($data['value']);
		}

		unset($sets);

		$option['attr']['value'] = (string)$data['value'];

		return slz_render_view(dirname(__FILE__) . '/view.php', compact('id', 'option', 'data', 'set'));
	}

	/**
	 * @internal
	 */
	protected function _get_value_from_input($option, $input_value)
	{
		if (is_null($input_value)) {
			return $option['value'];
		}

		$sets = $this->get_sets();

		if (isset($sets[ $option['set'] ])) {
			$set = $sets[ $option['set'] ];
		} else {
			$set = $this->generate_unknown_set($input_value);
		}

		unset($sets);

		if (!isset($set['icons'][ $input_value ])) {
			$input_value = $option['value'];
		}

		return (string)$input_value;
	}

	/**
	 * @internal
	 */
	protected function _get_defaults()
	{
		return array(
			'value' => '',
			'set'   => 'font-awesome',

		);
	}

	private function get_sets()
	{
		$cache_key = 'slz_option_type_icon/sets';

		try {
			return SLZ_Cache::get($cache_key);
		} catch (SLZ_Cache_Not_Found_Exception $e) {
			$sets = apply_filters('slz_option_type_icon_sets', $this->get_default_sets());

			// do not allow overwrite default sets
			$sets = array_merge($sets, $this->get_default_sets());

			SLZ_Cache::set($cache_key, $sets);

			return $sets;
		}
	}

	private function generate_unknown_set($icon)
	{
		return array(
			'font-style-src'  => 'data:text/css;charset=utf-8;base64,LyoqLw==', // fixme: WP will transform this to `http://domain.com/data:text/css;...`
			'container-class' => '',
			'groups' => array(
				'unknown' => __('Unknown Set', 'slz'),
			),
			'icons' => array(
				$icon => array('group' => 'unknown'),
			),
		);
	}

	private function get_default_sets()
	{
		// FIXME Maybe its better to use something like the following:
		//
		//     groups => array(
		//         array(
		//             'title' => __('Web Application Icons', 'slz')
		//             'icons' => array('fa fa-adjust', 'fa fa-anchor', ...),
		//         ),
		//         array(
		//             'title' => __('Transportation Icons', 'slz'),
		//             'icons' => array(...),
		//         ),
		//     )
		//
		// NOTE Take into account backward compatibility

		$icon_settings = array(
			'font-awesome' => array( // http://fortawesome.github.io/Font-Awesome/icons
				
				'font-style-src' => array(
					slz_get_framework_directory_uri('/static/libs/font-onicons/css/ionicons.min.css'),
					slz_get_framework_directory_uri('/static/libs/font-awesome/css/font-awesome.min.css'),
					slz_get_framework_directory_uri('/static/libs/font-open-iconic/css/open-iconic-bootstrap.css')
				),

				'container-class' => 'fa-lg', // some fonts need special wrapper class to display properly

				'font-type' => array (
					'awesome'     => __('Font Awesome', 'slz'),
					'ionicons'    => __('Font Ionicons', 'slz'),
					'openiconic'  => __('Font Open Iconic', 'slz')
				),
				'groups' => array (
					'web-application'   => array('font-type' =>'awesome','label' => __('__Web Application Icons', 'slz')),
					'hand'              => array('font-type' =>'awesome','label' => __('__Hand Icons', 'slz')),
					'transportation'    => array('font-type' =>'awesome','label' => __('__Transportation Icons', 'slz')),
					'gender'            => array('font-type' =>'awesome','label' => __('__Gender Icons', 'slz')),
					'file-type'         => array('font-type' =>'awesome','label' => __('__File Type Icons', 'slz')),
					'payment'           => array('font-type' =>'awesome','label' => __('__Payment Icons', 'slz')),
					'currency'          => array('font-type' =>'awesome','label' => __('__Currency Icons', 'slz')),
					'text-editor'       => array('font-type' =>'awesome','label' => __('__Text Editor Icons', 'slz')),
					'directional'       => array('font-type' =>'awesome','label' => __('__Directional Icons', 'slz')),
					'video-player'      => array('font-type' =>'awesome','label' => __('__Video Player Icons', 'slz')),
					'brand'             => array('font-type' =>'awesome','label' => __('__Brand Icons', 'slz')),
					'medical'           => array('font-type' =>'awesome','label' => __('__Medical Icons', 'slz')),
					
				),
				
				'icons' => array(
					//icon opennic

					'oi oi-account-login '  => array( 'group_id' =>'openiconic'),
					'oi oi-account-logout '  => array( 'group_id' =>'openiconic'),
					'oi oi-action-redo '  => array( 'group_id' =>'openiconic'),
					'oi oi-action-undo '  => array( 'group_id' =>'openiconic'),
					'oi oi-align-center '  => array( 'group_id' =>'openiconic'),
					'oi oi-align-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-align-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-aperture '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-bottom '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-circle-bottom '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-circle-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-circle-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-circle-top '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-thick-bottom '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-thick-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-thick-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-thick-top '  => array( 'group_id' =>'openiconic'),
					'oi oi-arrow-top '  => array( 'group_id' =>'openiconic'),
					'oi oi-audio-spectrum '  => array( 'group_id' =>'openiconic'),
					'oi oi-audio '  => array( 'group_id' =>'openiconic'),
					'oi oi-badge '  => array( 'group_id' =>'openiconic'),
					'oi oi-ban '  => array( 'group_id' =>'openiconic'),
					'oi oi-bar-chart '  => array( 'group_id' =>'openiconic'),
					'oi oi-basket '  => array( 'group_id' =>'openiconic'),
					'oi oi-battery-empty '  => array( 'group_id' =>'openiconic'),
					'oi oi-battery-full '  => array( 'group_id' =>'openiconic'),
					'oi oi-beaker '  => array( 'group_id' =>'openiconic'),
					'oi oi-bell '  => array( 'group_id' =>'openiconic'),
					'oi oi-bluetooth '  => array( 'group_id' =>'openiconic'),
					'oi oi-bold '  => array( 'group_id' =>'openiconic'),
					'oi oi-bolt '  => array( 'group_id' =>'openiconic'),
					'oi oi-book '  => array( 'group_id' =>'openiconic'),
					'oi oi-bookmark '  => array( 'group_id' =>'openiconic'),
					'oi oi-box '  => array( 'group_id' =>'openiconic'),
					'oi oi-briefcase '  => array( 'group_id' =>'openiconic'),
					'oi oi-british-pound '  => array( 'group_id' =>'openiconic'),
					'oi oi-browser '  => array( 'group_id' =>'openiconic'),
					'oi oi-brush '  => array( 'group_id' =>'openiconic'),
					'oi oi-bug '  => array( 'group_id' =>'openiconic'),
					'oi oi-bullhorn '  => array( 'group_id' =>'openiconic'),
					'oi oi-calculator '  => array( 'group_id' =>'openiconic'),
					'oi oi-calendar '  => array( 'group_id' =>'openiconic'),
					'oi oi-camera-slr '  => array( 'group_id' =>'openiconic'),
					'oi oi-caret-bottom '  => array( 'group_id' =>'openiconic'),
					'oi oi-caret-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-caret-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-caret-top '  => array( 'group_id' =>'openiconic'),
					'oi oi-cart '  => array( 'group_id' =>'openiconic'),
					'oi oi-chat '  => array( 'group_id' =>'openiconic'),
					'oi oi-check '  => array( 'group_id' =>'openiconic'),
					'oi oi-chevron-bottom '  => array( 'group_id' =>'openiconic'),
					'oi oi-chevron-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-chevron-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-chevron-top '  => array( 'group_id' =>'openiconic'),
					'oi oi-circle-check '  => array( 'group_id' =>'openiconic'),
					'oi oi-circle-x '  => array( 'group_id' =>'openiconic'),
					'oi oi-clipboard '  => array( 'group_id' =>'openiconic'),
					'oi oi-clock '  => array( 'group_id' =>'openiconic'),
					'oi oi-cloud-download '  => array( 'group_id' =>'openiconic'),
					'oi oi-cloud-upload '  => array( 'group_id' =>'openiconic'),
					'oi oi-cloud '  => array( 'group_id' =>'openiconic'),
					'oi oi-cloudy '  => array( 'group_id' =>'openiconic'),
					'oi oi-code '  => array( 'group_id' =>'openiconic'),
					'oi oi-cog '  => array( 'group_id' =>'openiconic'),
					'oi oi-collapse-down '  => array( 'group_id' =>'openiconic'),
					'oi oi-collapse-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-collapse-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-collapse-up '  => array( 'group_id' =>'openiconic'),
					'oi oi-command '  => array( 'group_id' =>'openiconic'),
					'oi oi-comment-square '  => array( 'group_id' =>'openiconic'),
					'oi oi-compass '  => array( 'group_id' =>'openiconic'),
					'oi oi-contrast '  => array( 'group_id' =>'openiconic'),
					'oi oi-copywriting '  => array( 'group_id' =>'openiconic'),
					'oi oi-credit-card '  => array( 'group_id' =>'openiconic'),
					'oi oi-crop '  => array( 'group_id' =>'openiconic'),
					'oi oi-dashboard '  => array( 'group_id' =>'openiconic'),
					'oi oi-data-transfer-download '  => array( 'group_id' =>'openiconic'),
					'oi oi-data-transfer-upload '  => array( 'group_id' =>'openiconic'),
					'oi oi-delete '  => array( 'group_id' =>'openiconic'),
					'oi oi-dial '  => array( 'group_id' =>'openiconic'),
					'oi oi-document '  => array( 'group_id' =>'openiconic'),
					'oi oi-dollar '  => array( 'group_id' =>'openiconic'),
					'oi oi-double-quote-sans-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-double-quote-sans-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-double-quote-serif-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-double-quote-serif-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-droplet '  => array( 'group_id' =>'openiconic'),
					'oi oi-eject '  => array( 'group_id' =>'openiconic'),
					'oi oi-elevator '  => array( 'group_id' =>'openiconic'),
					'oi oi-ellipses '  => array( 'group_id' =>'openiconic'),
					'oi oi-envelope-closed '  => array( 'group_id' =>'openiconic'),
					'oi oi-envelope-open '  => array( 'group_id' =>'openiconic'),
					'oi oi-euro '  => array( 'group_id' =>'openiconic'),
					'oi oi-excerpt '  => array( 'group_id' =>'openiconic'),
					'oi oi-expand-down '  => array( 'group_id' =>'openiconic'),
					'oi oi-expand-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-expand-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-expand-up '  => array( 'group_id' =>'openiconic'),
					'oi oi-external-link '  => array( 'group_id' =>'openiconic'),
					'oi oi-eye '  => array( 'group_id' =>'openiconic'),
					'oi oi-eyedropper '  => array( 'group_id' =>'openiconic'),
					'oi oi-file '  => array( 'group_id' =>'openiconic'),
					'oi oi-fire '  => array( 'group_id' =>'openiconic'),
					'oi oi-flag '  => array( 'group_id' =>'openiconic'),
					'oi oi-flash '  => array( 'group_id' =>'openiconic'),
					'oi oi-folder '  => array( 'group_id' =>'openiconic'),
					'oi oi-fork '  => array( 'group_id' =>'openiconic'),
					'oi oi-fullscreen-enter '  => array( 'group_id' =>'openiconic'),
					'oi oi-fullscreen-exit '  => array( 'group_id' =>'openiconic'),
					'oi oi-globe '  => array( 'group_id' =>'openiconic'),
					'oi oi-graph '  => array( 'group_id' =>'openiconic'),
					'oi oi-grid-four-up '  => array( 'group_id' =>'openiconic'),
					'oi oi-grid-three-up '  => array( 'group_id' =>'openiconic'),
					'oi oi-grid-two-up '  => array( 'group_id' =>'openiconic'),
					'oi oi-hard-drive '  => array( 'group_id' =>'openiconic'),
					'oi oi-header '  => array( 'group_id' =>'openiconic'),
					'oi oi-headphones '  => array( 'group_id' =>'openiconic'),
					'oi oi-heart '  => array( 'group_id' =>'openiconic'),
					'oi oi-home '  => array( 'group_id' =>'openiconic'),
					'oi oi-image '  => array( 'group_id' =>'openiconic'),
					'oi oi-inbox '  => array( 'group_id' =>'openiconic'),
					'oi oi-infinity '  => array( 'group_id' =>'openiconic'),
					'oi oi-info '  => array( 'group_id' =>'openiconic'),
					'oi oi-italic '  => array( 'group_id' =>'openiconic'),
					'oi oi-justify-center '  => array( 'group_id' =>'openiconic'),
					'oi oi-justify-left '  => array( 'group_id' =>'openiconic'),
					'oi oi-justify-right '  => array( 'group_id' =>'openiconic'),
					'oi oi-key '  => array( 'group_id' =>'openiconic'),
					'oi oi-laptop '  => array( 'group_id' =>'openiconic'),
					'oi oi-layers '  => array( 'group_id' =>'openiconic'),
					'oi oi-lightbulb '  => array( 'group_id' =>'openiconic'),
					'oi oi-link-broken '  => array( 'group_id' =>'openiconic'),
					'oi oi-link-intact '  => array( 'group_id' =>'openiconic'),
					'oi oi-list-rich '  => array( 'group_id' =>'openiconic'),
					'oi oi-list '  => array( 'group_id' =>'openiconic'),
					'oi oi-location '  => array( 'group_id' =>'openiconic'),
					'oi oi-lock-locked '  => array( 'group_id' =>'openiconic'),
					'oi oi-lock-unlocked '  => array( 'group_id' =>'openiconic'),
					'oi oi-loop-circular '  => array( 'group_id' =>'openiconic'),
					'oi oi-loop-square '  => array( 'group_id' =>'openiconic'),
					'oi oi-loop '  => array( 'group_id' =>'openiconic'),
					'oi oi-magnifying-glass '  => array( 'group_id' =>'openiconic'),
					'oi oi-map-marker '  => array( 'group_id' =>'openiconic'),
					'oi oi-map '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-pause '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-play '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-record '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-skip-backward '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-skip-forward '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-step-backward '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-step-forward '  => array( 'group_id' =>'openiconic'),
					'oi oi-media-stop '  => array( 'group_id' =>'openiconic'),
					'oi oi-medical-cross '  => array( 'group_id' =>'openiconic'),
					'oi oi-menu '  => array( 'group_id' =>'openiconic'),
					'oi oi-microphone '  => array( 'group_id' =>'openiconic'),
					'oi oi-minus '  => array( 'group_id' =>'openiconic'),
					'oi oi-monitor '  => array( 'group_id' =>'openiconic'),
					'oi oi-moon '  => array( 'group_id' =>'openiconic'),
					'oi oi-move '  => array( 'group_id' =>'openiconic'),
					'oi oi-musical-note '  => array( 'group_id' =>'openiconic'),
					'oi oi-paperclip '  => array( 'group_id' =>'openiconic'),
					'oi oi-pencil '  => array( 'group_id' =>'openiconic'),
					'oi oi-people '  => array( 'group_id' =>'openiconic'),
					'oi oi-person '  => array( 'group_id' =>'openiconic'),
					'oi oi-phone '  => array( 'group_id' =>'openiconic'),
					'oi oi-pie-chart '  => array( 'group_id' =>'openiconic'),
					'oi oi-pin '  => array( 'group_id' =>'openiconic'),
					'oi oi-play-circle '  => array( 'group_id' =>'openiconic'),
					'oi oi-plus '  => array( 'group_id' =>'openiconic'),
					'oi oi-power-standby '  => array( 'group_id' =>'openiconic'),
					'oi oi-print '  => array( 'group_id' =>'openiconic'),
					'oi oi-project '  => array( 'group_id' =>'openiconic'),
					'oi oi-pulse '  => array( 'group_id' =>'openiconic'),
					'oi oi-puzzle-piece '  => array( 'group_id' =>'openiconic'),
					'oi oi-question-mark '  => array( 'group_id' =>'openiconic'),
					'oi oi-rain '  => array( 'group_id' =>'openiconic'),
					'oi oi-random '  => array( 'group_id' =>'openiconic'),
					'oi oi-reload '  => array( 'group_id' =>'openiconic'),
					'oi oi-resize-both '  => array( 'group_id' =>'openiconic'),
					'oi oi-resize-height '  => array( 'group_id' =>'openiconic'),
					'oi oi-resize-width '  => array( 'group_id' =>'openiconic'),
					'oi oi-rss-alt '  => array( 'group_id' =>'openiconic'),
					'oi oi-rss '  => array( 'group_id' =>'openiconic'),
					'oi oi-script '  => array( 'group_id' =>'openiconic'),
					'oi oi-share-boxed '  => array( 'group_id' =>'openiconic'),
					'oi oi-share '  => array( 'group_id' =>'openiconic'),
					'oi oi-shield '  => array( 'group_id' =>'openiconic'),
					'oi oi-signal '  => array( 'group_id' =>'openiconic'),
					'oi oi-signpost '  => array( 'group_id' =>'openiconic'),
					'oi oi-sort-ascending '  => array( 'group_id' =>'openiconic'),
					'oi oi-sort-descending '  => array( 'group_id' =>'openiconic'),
					'oi oi-spreadsheet '  => array( 'group_id' =>'openiconic'),
					'oi oi-star '  => array( 'group_id' =>'openiconic'),
					'oi oi-sun '  => array( 'group_id' =>'openiconic'),
					'oi oi-tablet '  => array( 'group_id' =>'openiconic'),
					'oi oi-tag '  => array( 'group_id' =>'openiconic'),
					'oi oi-tags '  => array( 'group_id' =>'openiconic'),
					'oi oi-target '  => array( 'group_id' =>'openiconic'),
					'oi oi-task '  => array( 'group_id' =>'openiconic'),
					'oi oi-terminal '  => array( 'group_id' =>'openiconic'),
					'oi oi-text '  => array( 'group_id' =>'openiconic'),
					'oi oi-thumb-down '  => array( 'group_id' =>'openiconic'),
					'oi oi-thumb-up '  => array( 'group_id' =>'openiconic'),
					'oi oi-timer '  => array( 'group_id' =>'openiconic'),
					'oi oi-transfer '  => array( 'group_id' =>'openiconic'),
					'oi oi-trash '  => array( 'group_id' =>'openiconic'),
					'oi oi-underline '  => array( 'group_id' =>'openiconic'),
					'oi oi-vertical-align-bottom '  => array( 'group_id' =>'openiconic'),
					'oi oi-vertical-align-center '  => array( 'group_id' =>'openiconic'),
					'oi oi-vertical-align-top '  => array( 'group_id' =>'openiconic'),
					'oi oi-video '  => array( 'group_id' =>'openiconic'),
					'oi oi-volume-high '  => array( 'group_id' =>'openiconic'),
					'oi oi-volume-low '  => array( 'group_id' =>'openiconic'),
					'oi oi-volume-off '  => array( 'group_id' =>'openiconic'),
					'oi oi-warning '  => array( 'group_id' =>'openiconic'),
					'oi oi-wifi '  => array( 'group_id' =>'openiconic'),
					'oi oi-wrench '  => array( 'group_id' =>'openiconic'),
					'oi oi-x '  => array( 'group_id' =>'openiconic'),
					'oi oi-yen '  => array( 'group_id' =>'openiconic'),
					'oi oi-zoom-in '  => array( 'group_id' =>'openiconic'),
					'oi oi-zoom-out '  => array( 'group_id' =>'openiconic'),


					//icon ionicons
					'ion-alert' => array( 'group_id' =>'ionicons'),
					'ion-alert-circled' => array( 'group_id' =>'ionicons'),
					'ion-android-add' => array( 'group_id' =>'ionicons'),
					'ion-android-add-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-alarm-clock' => array( 'group_id' =>'ionicons'),
					'ion-android-alert' => array( 'group_id' =>'ionicons'),
					'ion-android-apps' => array( 'group_id' =>'ionicons'),
					'ion-android-archive' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-back' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-down' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropdown' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropdown-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropleft' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropleft-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropright' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropright-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropup' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-dropup-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-forward' => array( 'group_id' =>'ionicons'),
					'ion-android-arrow-up' => array( 'group_id' =>'ionicons'),
					'ion-android-attach' => array( 'group_id' =>'ionicons'),
					'ion-android-bar' => array( 'group_id' =>'ionicons'),
					'ion-android-bicycle' => array( 'group_id' =>'ionicons'),
					'ion-android-boat' => array( 'group_id' =>'ionicons'),
					'ion-android-bookmark' => array( 'group_id' =>'ionicons'),
					'ion-android-bulb' => array( 'group_id' =>'ionicons'),
					'ion-android-bus' => array( 'group_id' =>'ionicons'),
					'ion-android-calendar' => array( 'group_id' =>'ionicons'),
					'ion-android-call' => array( 'group_id' =>'ionicons'),
					'ion-android-camera' => array( 'group_id' =>'ionicons'),
					'ion-android-cancel' => array( 'group_id' =>'ionicons'),
					'ion-android-car' => array( 'group_id' =>'ionicons'),
					'ion-android-cart' => array( 'group_id' =>'ionicons'),
					'ion-android-chat' => array( 'group_id' =>'ionicons'),
					'ion-android-checkbox' => array( 'group_id' =>'ionicons'),
					'ion-android-checkbox-blank' => array( 'group_id' =>'ionicons'),
					'ion-android-checkbox-outline' => array( 'group_id' =>'ionicons'),
					'ion-android-checkbox-outline-blank' => array( 'group_id' =>'ionicons'),
					'ion-android-checkmark-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-clipboard' => array( 'group_id' =>'ionicons'),
					'ion-android-close' => array( 'group_id' =>'ionicons'),
					'ion-android-cloud' => array( 'group_id' =>'ionicons'),
					'ion-android-cloud-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-cloud-done' => array( 'group_id' =>'ionicons'),
					'ion-android-cloud-outline' => array( 'group_id' =>'ionicons'),
					'ion-android-color-palette' => array( 'group_id' =>'ionicons'),
					'ion-android-compass' => array( 'group_id' =>'ionicons'),
					'ion-android-contact' => array( 'group_id' =>'ionicons'),
					'ion-android-contacts' => array( 'group_id' =>'ionicons'),
					'ion-android-contract' => array( 'group_id' =>'ionicons'),
					'ion-android-create' => array( 'group_id' =>'ionicons'),
					'ion-android-delete' => array( 'group_id' =>'ionicons'),
					'ion-android-desktop' => array( 'group_id' =>'ionicons'),
					'ion-android-document' => array( 'group_id' =>'ionicons'),
					'ion-android-done' => array( 'group_id' =>'ionicons'),
					'ion-android-done-all' => array( 'group_id' =>'ionicons'),
					'ion-android-download' => array( 'group_id' =>'ionicons'),
					'ion-android-drafts' => array( 'group_id' =>'ionicons'),
					'ion-android-exit' => array( 'group_id' =>'ionicons'),
					'ion-android-expand' => array( 'group_id' =>'ionicons'),
					'ion-android-favorite' => array( 'group_id' =>'ionicons'),
					'ion-android-favorite-outline' => array( 'group_id' =>'ionicons'),
					'ion-android-film' => array( 'group_id' =>'ionicons'),
					'ion-android-folder' => array( 'group_id' =>'ionicons'),
					'ion-android-folder-open' => array( 'group_id' =>'ionicons'),
					'ion-android-funnel' => array( 'group_id' =>'ionicons'),
					'ion-android-globe' => array( 'group_id' =>'ionicons'),
					'ion-android-hand' => array( 'group_id' =>'ionicons'),
					'ion-android-hangout' => array( 'group_id' =>'ionicons'),
					'ion-android-happy' => array( 'group_id' =>'ionicons'),
					'ion-android-home' => array( 'group_id' =>'ionicons'),
					'ion-android-image' => array( 'group_id' =>'ionicons'),
					'ion-android-laptop' => array( 'group_id' =>'ionicons'),
					'ion-android-list' => array( 'group_id' =>'ionicons'),
					'ion-android-locate' => array( 'group_id' =>'ionicons'),
					'ion-android-lock' => array( 'group_id' =>'ionicons'),
					'ion-android-mail' => array( 'group_id' =>'ionicons'),
					'ion-android-map' => array( 'group_id' =>'ionicons'),
					'ion-android-menu' => array( 'group_id' =>'ionicons'),
					'ion-android-microphone' => array( 'group_id' =>'ionicons'),
					'ion-android-microphone-off' => array( 'group_id' =>'ionicons'),
					'ion-android-more-horizontal' => array( 'group_id' =>'ionicons'),
					'ion-android-more-vertical' => array( 'group_id' =>'ionicons'),
					'ion-android-navigate' => array( 'group_id' =>'ionicons'),
					'ion-android-notifications' => array( 'group_id' =>'ionicons'),
					'ion-android-notifications-none' => array( 'group_id' =>'ionicons'),
					'ion-android-notifications-off' => array( 'group_id' =>'ionicons'),
					'ion-android-open' => array( 'group_id' =>'ionicons'),
					'ion-android-options' => array( 'group_id' =>'ionicons'),
					'ion-android-people' => array( 'group_id' =>'ionicons'),
					'ion-android-person' => array( 'group_id' =>'ionicons'),
					'ion-android-person-add' => array( 'group_id' =>'ionicons'),
					'ion-android-phone-landscape' => array( 'group_id' =>'ionicons'),
					'ion-android-phone-portrait' => array( 'group_id' =>'ionicons'),
					'ion-android-pin' => array( 'group_id' =>'ionicons'),
					'ion-android-plane' => array( 'group_id' =>'ionicons'),
					'ion-android-playstore' => array( 'group_id' =>'ionicons'),
					'ion-android-print' => array( 'group_id' =>'ionicons'),
					'ion-android-radio-button-off' => array( 'group_id' =>'ionicons'),
					'ion-android-radio-button-on' => array( 'group_id' =>'ionicons'),
					'ion-android-refresh' => array( 'group_id' =>'ionicons'),
					'ion-android-remove' => array( 'group_id' =>'ionicons'),
					'ion-android-remove-circle' => array( 'group_id' =>'ionicons'),
					'ion-android-restaurant' => array( 'group_id' =>'ionicons'),
					'ion-android-sad' => array( 'group_id' =>'ionicons'),
					'ion-android-search' => array( 'group_id' =>'ionicons'),
					'ion-android-send' => array( 'group_id' =>'ionicons'),
					'ion-android-settings' => array( 'group_id' =>'ionicons'),
					'ion-android-share' => array( 'group_id' =>'ionicons'),
					'ion-android-share-alt' => array( 'group_id' =>'ionicons'),
					'ion-android-star' => array( 'group_id' =>'ionicons'),
					'ion-android-star-half' => array( 'group_id' =>'ionicons'),
					'ion-android-star-outline' => array( 'group_id' =>'ionicons'),
					'ion-android-stopwatch' => array( 'group_id' =>'ionicons'),
					'ion-android-subway' => array( 'group_id' =>'ionicons'),
					'ion-android-sunny' => array( 'group_id' =>'ionicons'),
					'ion-android-sync' => array( 'group_id' =>'ionicons'),
					'ion-android-textsms' => array( 'group_id' =>'ionicons'),
					'ion-android-time' => array( 'group_id' =>'ionicons'),
					'ion-android-train' => array( 'group_id' =>'ionicons'),
					'ion-android-unlock' => array( 'group_id' =>'ionicons'),
					'ion-android-upload' => array( 'group_id' =>'ionicons'),
					'ion-android-volume-down' => array( 'group_id' =>'ionicons'),
					'ion-android-volume-mute' => array( 'group_id' =>'ionicons'),
					'ion-android-volume-off' => array( 'group_id' =>'ionicons'),
					'ion-android-volume-up' => array( 'group_id' =>'ionicons'),
					'ion-android-walk' => array( 'group_id' =>'ionicons'),
					'ion-android-warning' => array( 'group_id' =>'ionicons'),
					'ion-android-watch' => array( 'group_id' =>'ionicons'),
					'ion-android-wifi' => array( 'group_id' =>'ionicons'),
					'ion-aperture' => array( 'group_id' =>'ionicons'),
					'ion-archive' => array( 'group_id' =>'ionicons'),
					'ion-arrow-down-a' => array( 'group_id' =>'ionicons'),
					'ion-arrow-down-b' => array( 'group_id' =>'ionicons'),
					'ion-arrow-down-c' => array( 'group_id' =>'ionicons'),
					'ion-arrow-expand' => array( 'group_id' =>'ionicons'),
					'ion-arrow-graph-down-left' => array( 'group_id' =>'ionicons'),
					'ion-arrow-graph-down-right' => array( 'group_id' =>'ionicons'),
					'ion-arrow-graph-up-left' => array( 'group_id' =>'ionicons'),
					'ion-arrow-graph-up-right' => array( 'group_id' =>'ionicons'),
					'ion-arrow-left-a' => array( 'group_id' =>'ionicons'),
					'ion-arrow-left-b' => array( 'group_id' =>'ionicons'),
					'ion-arrow-left-c' => array( 'group_id' =>'ionicons'),
					'ion-arrow-move' => array( 'group_id' =>'ionicons'),
					'ion-arrow-resize' => array( 'group_id' =>'ionicons'),
					'ion-arrow-return-left' => array( 'group_id' =>'ionicons'),
					'ion-arrow-return-right' => array( 'group_id' =>'ionicons'),
					'ion-arrow-right-a' => array( 'group_id' =>'ionicons'),
					'ion-arrow-right-b' => array( 'group_id' =>'ionicons'),
					'ion-arrow-right-c' => array( 'group_id' =>'ionicons'),
					'ion-arrow-shrink' => array( 'group_id' =>'ionicons'),
					'ion-arrow-swap' => array( 'group_id' =>'ionicons'),
					'ion-arrow-up-a' => array( 'group_id' =>'ionicons'),
					'ion-arrow-up-b' => array( 'group_id' =>'ionicons'),
					'ion-arrow-up-c' => array( 'group_id' =>'ionicons'),
					'ion-asterisk' => array( 'group_id' =>'ionicons'),
					'ion-at' => array( 'group_id' =>'ionicons'),
					'ion-backspace' => array( 'group_id' =>'ionicons'),
					'ion-backspace-outline' => array( 'group_id' =>'ionicons'),
					'ion-bag' => array( 'group_id' =>'ionicons'),
					'ion-battery-charging' => array( 'group_id' =>'ionicons'),
					'ion-battery-empty' => array( 'group_id' =>'ionicons'),
					'ion-battery-full' => array( 'group_id' =>'ionicons'),
					'ion-battery-half' => array( 'group_id' =>'ionicons'),
					'ion-battery-low' => array( 'group_id' =>'ionicons'),
					'ion-beaker' => array( 'group_id' =>'ionicons'),
					'ion-beer' => array( 'group_id' =>'ionicons'),
					'ion-bluetooth' => array( 'group_id' =>'ionicons'),
					'ion-bonfire' => array( 'group_id' =>'ionicons'),
					'ion-bookmark' => array( 'group_id' =>'ionicons'),
					'ion-bowtie' => array( 'group_id' =>'ionicons'),
					'ion-briefcase' => array( 'group_id' =>'ionicons'),
					'ion-bug' => array( 'group_id' =>'ionicons'),
					'ion-calculator' => array( 'group_id' =>'ionicons'),
					'ion-calendar' => array( 'group_id' =>'ionicons'),
					'ion-camera' => array( 'group_id' =>'ionicons'),
					'ion-card' => array( 'group_id' =>'ionicons'),
					'ion-cash' => array( 'group_id' =>'ionicons'),
					'ion-chatbox' => array( 'group_id' =>'ionicons'),
					'ion-chatbox-working' => array( 'group_id' =>'ionicons'),
					'ion-chatboxes' => array( 'group_id' =>'ionicons'),
					'ion-chatbubble' => array( 'group_id' =>'ionicons'),
					'ion-chatbubble-working' => array( 'group_id' =>'ionicons'),
					'ion-chatbubbles' => array( 'group_id' =>'ionicons'),
					'ion-checkmark' => array( 'group_id' =>'ionicons'),
					'ion-checkmark-circled' => array( 'group_id' =>'ionicons'),
					'ion-checkmark-round' => array( 'group_id' =>'ionicons'),
					'ion-chevron-down' => array( 'group_id' =>'ionicons'),
					'ion-chevron-left' => array( 'group_id' =>'ionicons'),
					'ion-chevron-right' => array( 'group_id' =>'ionicons'),
					'ion-chevron-up' => array( 'group_id' =>'ionicons'),
					'ion-clipboard' => array( 'group_id' =>'ionicons'),
					'ion-clock' => array( 'group_id' =>'ionicons'),
					'ion-close' => array( 'group_id' =>'ionicons'),
					'ion-close-circled' => array( 'group_id' =>'ionicons'),
					'ion-close-round' => array( 'group_id' =>'ionicons'),
					'ion-closed-captioning' => array( 'group_id' =>'ionicons'),
					'ion-cloud' => array( 'group_id' =>'ionicons'),
					'ion-code' => array( 'group_id' =>'ionicons'),
					'ion-code-download' => array( 'group_id' =>'ionicons'),
					'ion-code-working' => array( 'group_id' =>'ionicons'),
					'ion-coffee' => array( 'group_id' =>'ionicons'),
					'ion-compass' => array( 'group_id' =>'ionicons'),
					'ion-compose' => array( 'group_id' =>'ionicons'),
					'ion-connection-bars' => array( 'group_id' =>'ionicons'),
					'ion-contrast' => array( 'group_id' =>'ionicons'),
					'ion-crop' => array( 'group_id' =>'ionicons'),
					'ion-cube' => array( 'group_id' =>'ionicons'),
					'ion-disc' => array( 'group_id' =>'ionicons'),
					'ion-document' => array( 'group_id' =>'ionicons'),
					'ion-document-text' => array( 'group_id' =>'ionicons'),
					'ion-drag' => array( 'group_id' =>'ionicons'),
					'ion-earth' => array( 'group_id' =>'ionicons'),
					'ion-easel' => array( 'group_id' =>'ionicons'),
					'ion-edit' => array( 'group_id' =>'ionicons'),
					'ion-egg' => array( 'group_id' =>'ionicons'),
					'ion-eject' => array( 'group_id' =>'ionicons'),
					'ion-email' => array( 'group_id' =>'ionicons'),
					'ion-email-unread' => array( 'group_id' =>'ionicons'),
					'ion-erlenmeyer-flask' => array( 'group_id' =>'ionicons'),
					'ion-erlenmeyer-flask-bubbles' => array( 'group_id' =>'ionicons'),
					'ion-eye' => array( 'group_id' =>'ionicons'),
					'ion-eye-disabled' => array( 'group_id' =>'ionicons'),
					'ion-female' => array( 'group_id' =>'ionicons'),
					'ion-filing' => array( 'group_id' =>'ionicons'),
					'ion-film-marker' => array( 'group_id' =>'ionicons'),
					'ion-fireball' => array( 'group_id' =>'ionicons'),
					'ion-flag' => array( 'group_id' =>'ionicons'),
					'ion-flame' => array( 'group_id' =>'ionicons'),
					'ion-flash' => array( 'group_id' =>'ionicons'),
					'ion-flash-off' => array( 'group_id' =>'ionicons'),
					'ion-folder' => array( 'group_id' =>'ionicons'),
					'ion-fork' => array( 'group_id' =>'ionicons'),
					'ion-fork-repo' => array( 'group_id' =>'ionicons'),
					'ion-forward' => array( 'group_id' =>'ionicons'),
					'ion-funnel' => array( 'group_id' =>'ionicons'),
					'ion-gear-a' => array( 'group_id' =>'ionicons'),
					'ion-gear-b' => array( 'group_id' =>'ionicons'),
					'ion-grid' => array( 'group_id' =>'ionicons'),
					'ion-hammer' => array( 'group_id' =>'ionicons'),
					'ion-happy' => array( 'group_id' =>'ionicons'),
					'ion-happy-outline' => array( 'group_id' =>'ionicons'),
					'ion-headphone' => array( 'group_id' =>'ionicons'),
					'ion-heart' => array( 'group_id' =>'ionicons'),
					'ion-heart-broken' => array( 'group_id' =>'ionicons'),
					'ion-help' => array( 'group_id' =>'ionicons'),
					'ion-help-buoy' => array( 'group_id' =>'ionicons'),
					'ion-help-circled' => array( 'group_id' =>'ionicons'),
					'ion-home' => array( 'group_id' =>'ionicons'),
					'ion-icecream' => array( 'group_id' =>'ionicons'),
					'ion-image' => array( 'group_id' =>'ionicons'),
					'ion-images' => array( 'group_id' =>'ionicons'),
					'ion-information' => array( 'group_id' =>'ionicons'),
					'ion-information-circled' => array( 'group_id' =>'ionicons'),
					'ion-ionic' => array( 'group_id' =>'ionicons'),
					'ion-ios-alarm' => array( 'group_id' =>'ionicons'),
					'ion-ios-alarm-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-albums' => array( 'group_id' =>'ionicons'),
					'ion-ios-albums-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-americanfootball' => array( 'group_id' =>'ionicons'),
					'ion-ios-americanfootball-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-analytics' => array( 'group_id' =>'ionicons'),
					'ion-ios-analytics-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-back' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-down' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-forward' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-left' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-right' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-thin-down' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-thin-left' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-thin-right' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-thin-up' => array( 'group_id' =>'ionicons'),
					'ion-ios-arrow-up' => array( 'group_id' =>'ionicons'),
					'ion-ios-at' => array( 'group_id' =>'ionicons'),
					'ion-ios-at-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-barcode' => array( 'group_id' =>'ionicons'),
					'ion-ios-barcode-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-baseball' => array( 'group_id' =>'ionicons'),
					'ion-ios-baseball-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-basketball' => array( 'group_id' =>'ionicons'),
					'ion-ios-basketball-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-bell' => array( 'group_id' =>'ionicons'),
					'ion-ios-bell-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-body' => array( 'group_id' =>'ionicons'),
					'ion-ios-body-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-bolt' => array( 'group_id' =>'ionicons'),
					'ion-ios-bolt-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-book' => array( 'group_id' =>'ionicons'),
					'ion-ios-book-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-bookmarks' => array( 'group_id' =>'ionicons'),
					'ion-ios-bookmarks-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-box' => array( 'group_id' =>'ionicons'),
					'ion-ios-box-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-briefcase' => array( 'group_id' =>'ionicons'),
					'ion-ios-briefcase-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-browsers' => array( 'group_id' =>'ionicons'),
					'ion-ios-browsers-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-calculator' => array( 'group_id' =>'ionicons'),
					'ion-ios-calculator-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-calendar' => array( 'group_id' =>'ionicons'),
					'ion-ios-calendar-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-camera' => array( 'group_id' =>'ionicons'),
					'ion-ios-camera-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cart' => array( 'group_id' =>'ionicons'),
					'ion-ios-cart-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-chatboxes' => array( 'group_id' =>'ionicons'),
					'ion-ios-chatboxes-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-chatbubble' => array( 'group_id' =>'ionicons'),
					'ion-ios-chatbubble-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-checkmark' => array( 'group_id' =>'ionicons'),
					'ion-ios-checkmark-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-checkmark-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-circle-filled' => array( 'group_id' =>'ionicons'),
					'ion-ios-circle-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-clock' => array( 'group_id' =>'ionicons'),
					'ion-ios-clock-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-close' => array( 'group_id' =>'ionicons'),
					'ion-ios-close-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-close-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloud' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloud-download' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloud-download-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloud-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloud-upload' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloud-upload-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloudy' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloudy-night' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloudy-night-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cloudy-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-cog' => array( 'group_id' =>'ionicons'),
					'ion-ios-cog-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-color-filter' => array( 'group_id' =>'ionicons'),
					'ion-ios-color-filter-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-color-wand' => array( 'group_id' =>'ionicons'),
					'ion-ios-color-wand-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-compose' => array( 'group_id' =>'ionicons'),
					'ion-ios-compose-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-contact' => array( 'group_id' =>'ionicons'),
					'ion-ios-contact-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-copy' => array( 'group_id' =>'ionicons'),
					'ion-ios-copy-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-crop' => array( 'group_id' =>'ionicons'),
					'ion-ios-crop-strong' => array( 'group_id' =>'ionicons'),
					'ion-ios-download' => array( 'group_id' =>'ionicons'),
					'ion-ios-download-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-drag' => array( 'group_id' =>'ionicons'),
					'ion-ios-email' => array( 'group_id' =>'ionicons'),
					'ion-ios-email-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-eye' => array( 'group_id' =>'ionicons'),
					'ion-ios-eye-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-fastforward' => array( 'group_id' =>'ionicons'),
					'ion-ios-fastforward-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-filing' => array( 'group_id' =>'ionicons'),
					'ion-ios-filing-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-film' => array( 'group_id' =>'ionicons'),
					'ion-ios-film-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-flag' => array( 'group_id' =>'ionicons'),
					'ion-ios-flag-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-flame' => array( 'group_id' =>'ionicons'),
					'ion-ios-flame-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-flask' => array( 'group_id' =>'ionicons'),
					'ion-ios-flask-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-flower' => array( 'group_id' =>'ionicons'),
					'ion-ios-flower-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-folder' => array( 'group_id' =>'ionicons'),
					'ion-ios-folder-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-football' => array( 'group_id' =>'ionicons'),
					'ion-ios-football-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-game-controller-a' => array( 'group_id' =>'ionicons'),
					'ion-ios-game-controller-a-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-game-controller-b' => array( 'group_id' =>'ionicons'),
					'ion-ios-game-controller-b-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-gear' => array( 'group_id' =>'ionicons'),
					'ion-ios-gear-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-glasses' => array( 'group_id' =>'ionicons'),
					'ion-ios-glasses-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-grid-view' => array( 'group_id' =>'ionicons'),
					'ion-ios-grid-view-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-heart' => array( 'group_id' =>'ionicons'),
					'ion-ios-heart-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-help' => array( 'group_id' =>'ionicons'),
					'ion-ios-help-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-help-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-home' => array( 'group_id' =>'ionicons'),
					'ion-ios-home-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-infinite' => array( 'group_id' =>'ionicons'),
					'ion-ios-infinite-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-information' => array( 'group_id' =>'ionicons'),
					'ion-ios-information-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-information-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-ionic-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-keypad' => array( 'group_id' =>'ionicons'),
					'ion-ios-keypad-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-lightbulb' => array( 'group_id' =>'ionicons'),
					'ion-ios-lightbulb-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-list' => array( 'group_id' =>'ionicons'),
					'ion-ios-list-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-location' => array( 'group_id' =>'ionicons'),
					'ion-ios-location-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-locked' => array( 'group_id' =>'ionicons'),
					'ion-ios-locked-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-loop' => array( 'group_id' =>'ionicons'),
					'ion-ios-loop-strong' => array( 'group_id' =>'ionicons'),
					'ion-ios-medical' => array( 'group_id' =>'ionicons'),
					'ion-ios-medical-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-medkit' => array( 'group_id' =>'ionicons'),
					'ion-ios-medkit-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-mic' => array( 'group_id' =>'ionicons'),
					'ion-ios-mic-off' => array( 'group_id' =>'ionicons'),
					'ion-ios-mic-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-minus' => array( 'group_id' =>'ionicons'),
					'ion-ios-minus-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-minus-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-monitor' => array( 'group_id' =>'ionicons'),
					'ion-ios-monitor-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-moon' => array( 'group_id' =>'ionicons'),
					'ion-ios-moon-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-more' => array( 'group_id' =>'ionicons'),
					'ion-ios-more-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-musical-note' => array( 'group_id' =>'ionicons'),
					'ion-ios-musical-notes' => array( 'group_id' =>'ionicons'),
					'ion-ios-navigate' => array( 'group_id' =>'ionicons'),
					'ion-ios-navigate-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-nutrition' => array( 'group_id' =>'ionicons'),
					'ion-ios-nutrition-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-paper' => array( 'group_id' =>'ionicons'),
					'ion-ios-paper-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-paperplane' => array( 'group_id' =>'ionicons'),
					'ion-ios-paperplane-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-partlysunny' => array( 'group_id' =>'ionicons'),
					'ion-ios-partlysunny-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-pause' => array( 'group_id' =>'ionicons'),
					'ion-ios-pause-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-paw' => array( 'group_id' =>'ionicons'),
					'ion-ios-paw-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-people' => array( 'group_id' =>'ionicons'),
					'ion-ios-people-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-person' => array( 'group_id' =>'ionicons'),
					'ion-ios-person-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-personadd' => array( 'group_id' =>'ionicons'),
					'ion-ios-personadd-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-photos' => array( 'group_id' =>'ionicons'),
					'ion-ios-photos-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-pie' => array( 'group_id' =>'ionicons'),
					'ion-ios-pie-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-pint' => array( 'group_id' =>'ionicons'),
					'ion-ios-pint-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-play' => array( 'group_id' =>'ionicons'),
					'ion-ios-play-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-plus' => array( 'group_id' =>'ionicons'),
					'ion-ios-plus-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-plus-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-pricetag' => array( 'group_id' =>'ionicons'),
					'ion-ios-pricetag-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-pricetags' => array( 'group_id' =>'ionicons'),
					'ion-ios-pricetags-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-printer' => array( 'group_id' =>'ionicons'),
					'ion-ios-printer-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-pulse' => array( 'group_id' =>'ionicons'),
					'ion-ios-pulse-strong' => array( 'group_id' =>'ionicons'),
					'ion-ios-rainy' => array( 'group_id' =>'ionicons'),
					'ion-ios-rainy-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-recording' => array( 'group_id' =>'ionicons'),
					'ion-ios-recording-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-redo' => array( 'group_id' =>'ionicons'),
					'ion-ios-redo-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-refresh' => array( 'group_id' =>'ionicons'),
					'ion-ios-refresh-empty' => array( 'group_id' =>'ionicons'),
					'ion-ios-refresh-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-reload' => array( 'group_id' =>'ionicons'),
					'ion-ios-reverse-camera' => array( 'group_id' =>'ionicons'),
					'ion-ios-reverse-camera-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-rewind' => array( 'group_id' =>'ionicons'),
					'ion-ios-rewind-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-rose' => array( 'group_id' =>'ionicons'),
					'ion-ios-rose-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-search' => array( 'group_id' =>'ionicons'),
					'ion-ios-search-strong' => array( 'group_id' =>'ionicons'),
					'ion-ios-settings' => array( 'group_id' =>'ionicons'),
					'ion-ios-settings-strong' => array( 'group_id' =>'ionicons'),
					'ion-ios-shuffle' => array( 'group_id' =>'ionicons'),
					'ion-ios-shuffle-strong' => array( 'group_id' =>'ionicons'),
					'ion-ios-skipbackward' => array( 'group_id' =>'ionicons'),
					'ion-ios-skipbackward-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-skipforward' => array( 'group_id' =>'ionicons'),
					'ion-ios-skipforward-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-snowy' => array( 'group_id' =>'ionicons'),
					'ion-ios-speedometer' => array( 'group_id' =>'ionicons'),
					'ion-ios-speedometer-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-star' => array( 'group_id' =>'ionicons'),
					'ion-ios-star-half' => array( 'group_id' =>'ionicons'),
					'ion-ios-star-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-stopwatch' => array( 'group_id' =>'ionicons'),
					'ion-ios-stopwatch-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-sunny' => array( 'group_id' =>'ionicons'),
					'ion-ios-sunny-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-telephone' => array( 'group_id' =>'ionicons'),
					'ion-ios-telephone-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-tennisball' => array( 'group_id' =>'ionicons'),
					'ion-ios-tennisball-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-thunderstorm' => array( 'group_id' =>'ionicons'),
					'ion-ios-thunderstorm-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-time' => array( 'group_id' =>'ionicons'),
					'ion-ios-time-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-timer' => array( 'group_id' =>'ionicons'),
					'ion-ios-timer-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-toggle' => array( 'group_id' =>'ionicons'),
					'ion-ios-toggle-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-trash' => array( 'group_id' =>'ionicons'),
					'ion-ios-trash-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-undo' => array( 'group_id' =>'ionicons'),
					'ion-ios-undo-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-unlocked' => array( 'group_id' =>'ionicons'),
					'ion-ios-unlocked-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-upload' => array( 'group_id' =>'ionicons'),
					'ion-ios-upload-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-videocam' => array( 'group_id' =>'ionicons'),
					'ion-ios-videocam-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-volume-high' => array( 'group_id' =>'ionicons'),
					'ion-ios-volume-low' => array( 'group_id' =>'ionicons'),
					'ion-ios-wineglass' => array( 'group_id' =>'ionicons'),
					'ion-ios-wineglass-outline' => array( 'group_id' =>'ionicons'),
					'ion-ios-world' => array( 'group_id' =>'ionicons'),
					'ion-ios-world-outline' => array( 'group_id' =>'ionicons'),
					'ion-ipad' => array( 'group_id' =>'ionicons'),
					'ion-iphone' => array( 'group_id' =>'ionicons'),
					'ion-ipod' => array( 'group_id' =>'ionicons'),
					'ion-jet' => array( 'group_id' =>'ionicons'),
					'ion-key' => array( 'group_id' =>'ionicons'),
					'ion-knife' => array( 'group_id' =>'ionicons'),
					'ion-laptop' => array( 'group_id' =>'ionicons'),
					'ion-leaf' => array( 'group_id' =>'ionicons'),
					'ion-levels' => array( 'group_id' =>'ionicons'),
					'ion-lightbulb' => array( 'group_id' =>'ionicons'),
					'ion-link' => array( 'group_id' =>'ionicons'),
					'ion-load-a' => array( 'group_id' =>'ionicons'),
					'ion-load-b' => array( 'group_id' =>'ionicons'),
					'ion-load-c' => array( 'group_id' =>'ionicons'),
					'ion-load-d' => array( 'group_id' =>'ionicons'),
					'ion-location' => array( 'group_id' =>'ionicons'),
					'ion-lock-combination' => array( 'group_id' =>'ionicons'),
					'ion-locked' => array( 'group_id' =>'ionicons'),
					'ion-log-in' => array( 'group_id' =>'ionicons'),
					'ion-log-out' => array( 'group_id' =>'ionicons'),
					'ion-loop' => array( 'group_id' =>'ionicons'),
					'ion-magnet' => array( 'group_id' =>'ionicons'),
					'ion-male' => array( 'group_id' =>'ionicons'),
					'ion-man' => array( 'group_id' =>'ionicons'),
					'ion-map' => array( 'group_id' =>'ionicons'),
					'ion-medkit' => array( 'group_id' =>'ionicons'),
					'ion-merge' => array( 'group_id' =>'ionicons'),
					'ion-mic-a' => array( 'group_id' =>'ionicons'),
					'ion-mic-b' => array( 'group_id' =>'ionicons'),
					'ion-mic-c' => array( 'group_id' =>'ionicons'),
					'ion-minus' => array( 'group_id' =>'ionicons'),
					'ion-minus-circled' => array( 'group_id' =>'ionicons'),
					'ion-minus-round' => array( 'group_id' =>'ionicons'),
					'ion-model-s' => array( 'group_id' =>'ionicons'),
					'ion-monitor' => array( 'group_id' =>'ionicons'),
					'ion-more' => array( 'group_id' =>'ionicons'),
					'ion-mouse' => array( 'group_id' =>'ionicons'),
					'ion-music-note' => array( 'group_id' =>'ionicons'),
					'ion-navicon' => array( 'group_id' =>'ionicons'),
					'ion-navicon-round' => array( 'group_id' =>'ionicons'),
					'ion-navigate' => array( 'group_id' =>'ionicons'),
					'ion-network' => array( 'group_id' =>'ionicons'),
					'ion-no-smoking' => array( 'group_id' =>'ionicons'),
					'ion-nuclear' => array( 'group_id' =>'ionicons'),
					'ion-outlet' => array( 'group_id' =>'ionicons'),
					'ion-paintbrush' => array( 'group_id' =>'ionicons'),
					'ion-paintbucket' => array( 'group_id' =>'ionicons'),
					'ion-paper-airplane' => array( 'group_id' =>'ionicons'),
					'ion-paperclip' => array( 'group_id' =>'ionicons'),
					'ion-pause' => array( 'group_id' =>'ionicons'),
					'ion-person' => array( 'group_id' =>'ionicons'),
					'ion-person-add' => array( 'group_id' =>'ionicons'),
					'ion-person-stalker' => array( 'group_id' =>'ionicons'),
					'ion-pie-graph' => array( 'group_id' =>'ionicons'),
					'ion-pin' => array( 'group_id' =>'ionicons'),
					'ion-pinpoint' => array( 'group_id' =>'ionicons'),
					'ion-pizza' => array( 'group_id' =>'ionicons'),
					'ion-plane' => array( 'group_id' =>'ionicons'),
					'ion-planet' => array( 'group_id' =>'ionicons'),
					'ion-play' => array( 'group_id' =>'ionicons'),
					'ion-playstation' => array( 'group_id' =>'ionicons'),
					'ion-plus' => array( 'group_id' =>'ionicons'),
					'ion-plus-circled' => array( 'group_id' =>'ionicons'),
					'ion-plus-round' => array( 'group_id' =>'ionicons'),
					'ion-podium' => array( 'group_id' =>'ionicons'),
					'ion-pound' => array( 'group_id' =>'ionicons'),
					'ion-power' => array( 'group_id' =>'ionicons'),
					'ion-pricetag' => array( 'group_id' =>'ionicons'),
					'ion-pricetags' => array( 'group_id' =>'ionicons'),
					'ion-printer' => array( 'group_id' =>'ionicons'),
					'ion-pull-request' => array( 'group_id' =>'ionicons'),
					'ion-qr-scanner' => array( 'group_id' =>'ionicons'),
					'ion-quote' => array( 'group_id' =>'ionicons'),
					'ion-radio-waves' => array( 'group_id' =>'ionicons'),
					'ion-record' => array( 'group_id' =>'ionicons'),
					'ion-refresh' => array( 'group_id' =>'ionicons'),
					'ion-reply' => array( 'group_id' =>'ionicons'),
					'ion-reply-all' => array( 'group_id' =>'ionicons'),
					'ion-ribbon-a' => array( 'group_id' =>'ionicons'),
					'ion-ribbon-b' => array( 'group_id' =>'ionicons'),
					'ion-sad' => array( 'group_id' =>'ionicons'),
					'ion-sad-outline' => array( 'group_id' =>'ionicons'),
					'ion-scissors' => array( 'group_id' =>'ionicons'),
					'ion-search' => array( 'group_id' =>'ionicons'),
					'ion-settings' => array( 'group_id' =>'ionicons'),
					'ion-share' => array( 'group_id' =>'ionicons'),
					'ion-shuffle' => array( 'group_id' =>'ionicons'),
					'ion-skip-backward' => array( 'group_id' =>'ionicons'),
					'ion-skip-forward' => array( 'group_id' =>'ionicons'),
					'ion-social-android' => array( 'group_id' =>'ionicons'),
					'ion-social-android-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-angular' => array( 'group_id' =>'ionicons'),
					'ion-social-angular-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-apple' => array( 'group_id' =>'ionicons'),
					'ion-social-apple-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-bitcoin' => array( 'group_id' =>'ionicons'),
					'ion-social-bitcoin-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-buffer' => array( 'group_id' =>'ionicons'),
					'ion-social-buffer-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-chrome' => array( 'group_id' =>'ionicons'),
					'ion-social-chrome-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-codepen' => array( 'group_id' =>'ionicons'),
					'ion-social-codepen-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-css3' => array( 'group_id' =>'ionicons'),
					'ion-social-css3-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-designernews' => array( 'group_id' =>'ionicons'),
					'ion-social-designernews-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-dribbble' => array( 'group_id' =>'ionicons'),
					'ion-social-dribbble-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-dropbox' => array( 'group_id' =>'ionicons'),
					'ion-social-dropbox-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-euro' => array( 'group_id' =>'ionicons'),
					'ion-social-euro-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-facebook' => array( 'group_id' =>'ionicons'),
					'ion-social-facebook-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-foursquare' => array( 'group_id' =>'ionicons'),
					'ion-social-foursquare-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-freebsd-devil' => array( 'group_id' =>'ionicons'),
					'ion-social-github' => array( 'group_id' =>'ionicons'),
					'ion-social-github-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-google' => array( 'group_id' =>'ionicons'),
					'ion-social-google-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-googleplus' => array( 'group_id' =>'ionicons'),
					'ion-social-googleplus-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-hackernews' => array( 'group_id' =>'ionicons'),
					'ion-social-hackernews-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-html5' => array( 'group_id' =>'ionicons'),
					'ion-social-html5-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-instagram' => array( 'group_id' =>'ionicons'),
					'ion-social-instagram-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-javascript' => array( 'group_id' =>'ionicons'),
					'ion-social-javascript-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-linkedin' => array( 'group_id' =>'ionicons'),
					'ion-social-linkedin-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-markdown' => array( 'group_id' =>'ionicons'),
					'ion-social-nodejs' => array( 'group_id' =>'ionicons'),
					'ion-social-octocat' => array( 'group_id' =>'ionicons'),
					'ion-social-pinterest' => array( 'group_id' =>'ionicons'),
					'ion-social-pinterest-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-python' => array( 'group_id' =>'ionicons'),
					'ion-social-reddit' => array( 'group_id' =>'ionicons'),
					'ion-social-reddit-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-rss' => array( 'group_id' =>'ionicons'),
					'ion-social-rss-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-sass' => array( 'group_id' =>'ionicons'),
					'ion-social-skype' => array( 'group_id' =>'ionicons'),
					'ion-social-skype-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-snapchat' => array( 'group_id' =>'ionicons'),
					'ion-social-snapchat-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-tumblr' => array( 'group_id' =>'ionicons'),
					'ion-social-tumblr-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-tux' => array( 'group_id' =>'ionicons'),
					'ion-social-twitch' => array( 'group_id' =>'ionicons'),
					'ion-social-twitch-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-twitter' => array( 'group_id' =>'ionicons'),
					'ion-social-twitter-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-usd' => array( 'group_id' =>'ionicons'),
					'ion-social-usd-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-vimeo' => array( 'group_id' =>'ionicons'),
					'ion-social-vimeo-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-whatsapp' => array( 'group_id' =>'ionicons'),
					'ion-social-whatsapp-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-windows' => array( 'group_id' =>'ionicons'),
					'ion-social-windows-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-wordpress' => array( 'group_id' =>'ionicons'),
					'ion-social-wordpress-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-yahoo' => array( 'group_id' =>'ionicons'),
					'ion-social-yahoo-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-yen' => array( 'group_id' =>'ionicons'),
					'ion-social-yen-outline' => array( 'group_id' =>'ionicons'),
					'ion-social-youtube' => array( 'group_id' =>'ionicons'),
					'ion-social-youtube-outline' => array( 'group_id' =>'ionicons'),
					'ion-soup-can' => array( 'group_id' =>'ionicons'),
					'ion-soup-can-outline' => array( 'group_id' =>'ionicons'),
					'ion-speakerphone' => array( 'group_id' =>'ionicons'),
					'ion-speedometer' => array( 'group_id' =>'ionicons'),
					'ion-spoon' => array( 'group_id' =>'ionicons'),
					'ion-star' => array( 'group_id' =>'ionicons'),
					'ion-stats-bars' => array( 'group_id' =>'ionicons'),
					'ion-steam' => array( 'group_id' =>'ionicons'),
					'ion-stop' => array( 'group_id' =>'ionicons'),
					'ion-thermometer' => array( 'group_id' =>'ionicons'),
					'ion-thumbsdown' => array( 'group_id' =>'ionicons'),
					'ion-thumbsup' => array( 'group_id' =>'ionicons'),
					'ion-toggle' => array( 'group_id' =>'ionicons'),
					'ion-toggle-filled' => array( 'group_id' =>'ionicons'),
					'ion-transgender' => array( 'group_id' =>'ionicons'),
					'ion-trash-a' => array( 'group_id' =>'ionicons'),
					'ion-trash-b' => array( 'group_id' =>'ionicons'),
					'ion-trophy' => array( 'group_id' =>'ionicons'),
					'ion-tshirt' => array( 'group_id' =>'ionicons'),
					'ion-tshirt-outline' => array( 'group_id' =>'ionicons'),
					'ion-umbrella' => array( 'group_id' =>'ionicons'),
					'ion-university' => array( 'group_id' =>'ionicons'),
					'ion-unlocked' => array( 'group_id' =>'ionicons'),
					'ion-upload' => array( 'group_id' =>'ionicons'),
					'ion-usb' => array( 'group_id' =>'ionicons'),
					'ion-videocamera' => array( 'group_id' =>'ionicons'),
					'ion-volume-high' => array( 'group_id' =>'ionicons'),
					'ion-volume-low' => array( 'group_id' =>'ionicons'),
					'ion-volume-medium' => array( 'group_id' =>'ionicons'),
					'ion-volume-mute' => array( 'group_id' =>'ionicons'),
					'ion-wand' => array( 'group_id' =>'ionicons'),
					'ion-waterdrop' => array( 'group_id' =>'ionicons'),
					'ion-wifi' => array( 'group_id' =>'ionicons'),
					'ion-wineglass' => array( 'group_id' =>'ionicons'),
					'ion-woman' => array( 'group_id' =>'ionicons'),
					'ion-wrench' => array( 'group_id' =>'ionicons'),
					'ion-xbox' => array( 'group_id' =>'ionicons'),
									

					// font awesome
					'fa fa-adjust' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-american-sign-language-interpreting' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-anchor' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-archive' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-area-chart' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-arrows' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-arrows-h' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-arrows-v' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-asl-interpreting' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-assistive-listening-systems' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-asterisk' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-at' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-audio-description' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-automobile' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-balance-scale' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-ban' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bank' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bar-chart' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bar-chart-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-barcode' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bars' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-0' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-1' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-2' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-3' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-4' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-empty' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-full' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-half' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-quarter' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-battery-three-quarters' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bed' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-beer' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bell' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bell-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bell-slash' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bell-slash-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bicycle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-binoculars' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-birthday-cake' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-blind' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bluetooth' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bluetooth-b' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bolt' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bomb' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-book' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bookmark' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bookmark-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-braille' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-briefcase' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bug' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-building' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-building-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bullhorn' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bullseye' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-bus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cab' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calculator' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calendar' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calendar-check-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calendar-minus-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calendar-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calendar-plus-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-calendar-times-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-camera' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-camera-retro' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-car' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-caret-square-o-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-caret-square-o-left' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-caret-square-o-right' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-caret-square-o-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cart-arrow-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cart-plus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-certificate' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-check' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-check-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-check-circle-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-check-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-check-square-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-child' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-circle-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-circle-o-notch' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-circle-thin' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-clock-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-clone' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-close' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cloud' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cloud-download' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cloud-upload' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-code' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-code-fork' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-coffee' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cog' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cogs' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-comment' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-comment-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-commenting' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-commenting-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-comments' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-comments-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-compass' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-copyright' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-creative-commons' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-credit-card' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-credit-card-alt' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-crop' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-crosshairs' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cube' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cubes' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-cutlery' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-dashboard' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-database' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-deaf' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-deafness' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-desktop' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-diamond' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-dot-circle-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-download' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-edit' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-ellipsis-h' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-ellipsis-v' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-envelope' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-envelope-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-envelope-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-eraser' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-exchange' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-exclamation' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-exclamation-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-exclamation-triangle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-external-link' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-external-link-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-eye' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-eye-slash' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-eyedropper' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-fax' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-feed' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-female' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-fighter-jet' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-archive-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-audio-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-code-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-excel-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-image-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-movie-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-pdf-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-photo-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-picture-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-powerpoint-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-sound-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-video-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-word-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-file-zip-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-film' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-filter' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-fire' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-fire-extinguisher' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-flag' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-flag-checkered' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-flag-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-flash' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-flask' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-folder' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-folder-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-folder-open' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-folder-open-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-frown-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-futbol-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-gamepad' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-gavel' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-gear' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-gears' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-gift' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-glass' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-globe' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-graduation-cap' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-group' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-grab-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-lizard-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-paper-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-peace-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-pointer-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-rock-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-scissors-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-spock-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-stop-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hard-of-hearing' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hashtag' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hdd-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-headphones' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-heart' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-heart-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-heartbeat' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-history' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-home' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hotel' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-1' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-2' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-3' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-end' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-half' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hourglass-start' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-i-cursor' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-image' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-inbox' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-industry' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-info' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-info-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-institution' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-key' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-keyboard-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-language' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-laptop' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-leaf' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-legal' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-lemon-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-level-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-level-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-life-bouy' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-life-buoy' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-life-ring' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-life-saver' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-lightbulb-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-line-chart' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-location-arrow' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-lock' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-low-vision' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-magic' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-magnet' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mail-forward' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mail-reply' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mail-reply-all' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-male' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-map' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-map-marker' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-map-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-map-pin' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-map-signs' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-meh-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-microphone' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-microphone-slash' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-minus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-minus-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-minus-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-minus-square-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mobile' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mobile-phone' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-money' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-moon-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mortar-board' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-motorcycle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-mouse-pointer' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-music' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-navicon' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-newspaper-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-object-group' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-object-ungroup' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-paint-brush' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-paper-plane' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-paper-plane-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-paw' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-pencil' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-pencil-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-pencil-square-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-percent' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-phone' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-phone-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-photo' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-picture-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-pie-chart' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-plane' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-plug' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-plus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-plus-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-plus-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-plus-square-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-power-off' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-print' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-puzzle-piece' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-qrcode' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-question' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-question-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-question-circle-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-quote-left' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-quote-right' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-random' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-recycle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-refresh' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-registered' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-remove' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-reorder' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-reply' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-reply-all' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-retweet' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-road' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-rocket' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-rss' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-rss-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-search' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-search-minus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-search-plus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-send' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-send-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-server' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-share' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-share-alt' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-share-alt-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-share-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-share-square-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-shield' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-ship' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-shopping-bag' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-shopping-basket' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-shopping-cart' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sign-in' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sign-language' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sign-out' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-signal' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-signing' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sitemap' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sliders' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-smile-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-soccer-ball-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-alpha-asc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-alpha-desc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-amount-asc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-amount-desc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-asc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-desc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-numeric-asc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-numeric-desc' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sort-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-space-shuttle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					//'fa fa-spinner' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-spoon' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-square' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-square-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-star' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-star-half' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-star-half-empty' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-star-half-full' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-star-half-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-star-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sticky-note' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sticky-note-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-street-view' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-suitcase' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-sun-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-support' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tablet' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tachometer' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tag' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tags' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tasks' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-taxi' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-television' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-terminal' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-thumb-tack' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-thumbs-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-thumbs-o-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-thumbs-o-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-thumbs-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-ticket' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-times' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-times-circle' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-times-circle-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tint' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-toggle-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-toggle-left' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-toggle-off' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-toggle-on' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-toggle-right' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-toggle-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-trademark' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-trash' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-trash-o' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tree' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-trophy' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-truck' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tty' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-tv' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-umbrella' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-universal-access' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-university' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-unlock' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-unlock-alt' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-unsorted' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-upload' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-user' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-user-plus' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-user-secret' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-user-times' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-users' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-video-camera' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-volume-control-phone' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-volume-down' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-volume-off' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-volume-up' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-warning' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-wheelchair' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-wheelchair-alt' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-wifi' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-wrench' => array( 'group' => 'web-application','group_id' =>'awesome'),
					'fa fa-hand-o-down' => array( 'group' => 'hand','group_id' =>'awesome'),
					'fa fa-hand-o-left' => array( 'group' => 'hand','group_id' =>'awesome'),
					'fa fa-hand-o-right' => array( 'group' => 'hand','group_id' =>'awesome'),
					'fa fa-hand-o-up' => array( 'group' => 'hand','group_id' =>'awesome'),
					'fa fa-ambulance' => array( 'group' => 'transportation','group_id' =>'awesome'),
					'fa fa-subway' => array( 'group' => 'transportation','group_id' =>'awesome'),
					'fa fa-train' => array( 'group' => 'transportation','group_id' =>'awesome'),
					'fa fa-genderless' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-intersex' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-mars' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-mars-double' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-mars-stroke' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-mars-stroke-h' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-mars-stroke-v' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-mercury' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-neuter' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-transgender' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-transgender-alt' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-venus' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-venus-double' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-venus-mars' => array( 'group' => 'gender','group_id' =>'awesome'),
					'fa fa-file' => array( 'group' => 'file-type','group_id' =>'awesome'),
					'fa fa-file-o' => array( 'group' => 'file-type','group_id' =>'awesome'),
					'fa fa-file-text' => array( 'group' => 'file-type','group_id' =>'awesome'),
					'fa fa-file-text-o' => array( 'group' => 'file-type','group_id' =>'awesome'),
					'fa fa-cc-amex' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-diners-club' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-discover' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-jcb' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-mastercard' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-paypal' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-stripe' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-cc-visa' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-google-wallet' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-paypal' => array( 'group' => 'payment','group_id' =>'awesome'),
					'fa fa-bitcoin' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-btc' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-cny' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-dollar' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-eur' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-euro' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-gbp' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-gg' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-gg-circle' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-ils' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-inr' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-jpy' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-krw' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-rmb' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-rouble' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-rub' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-ruble' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-rupee' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-shekel' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-sheqel' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-try' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-turkish-lira' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-usd' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-won' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-yen' => array( 'group' => 'currency','group_id' =>'awesome'),
					'fa fa-align-center' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-align-justify' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-align-left' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-align-right' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-bold' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-chain' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-chain-broken' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-clipboard' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-columns' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-copy' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-cut' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-dedent' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-files-o' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-floppy-o' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-font' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-header' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-indent' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-italic' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-link' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-list' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-list-alt' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-list-ol' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-list-ul' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-outdent' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-paperclip' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-paragraph' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-paste' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-repeat' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-rotate-left' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-rotate-right' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-save' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-scissors' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-strikethrough' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-subscript' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-superscript' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-table' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-text-height' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-text-width' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-th' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-th-large' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-th-list' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-underline' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-undo' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-unlink' => array( 'group' => 'text-editor','group_id' =>'awesome'),
					'fa fa-angle-double-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-double-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-double-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-double-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-angle-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-o-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-o-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-o-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-o-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-circle-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrow-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-arrows-alt' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-caret-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-caret-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-caret-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-caret-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-circle-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-circle-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-circle-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-circle-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-chevron-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-long-arrow-down' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-long-arrow-left' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-long-arrow-right' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-long-arrow-up' => array( 'group' => 'directional','group_id' =>'awesome'),
					'fa fa-backward' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-compress' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-eject' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-expand' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-fast-backward' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-fast-forward' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-forward' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-pause' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-pause-circle' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-pause-circle-o' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-play' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-play-circle' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-play-circle-o' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-step-backward' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-step-forward' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-stop' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-stop-circle' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-stop-circle-o' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-youtube-play' => array( 'group' => 'video-player','group_id' =>'awesome'),
					'fa fa-500px' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-adn' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-amazon' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-android' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-angellist' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-apple' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-behance' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-behance-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-bitbucket' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-bitbucket-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-black-tie' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-buysellads' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-chrome' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-codepen' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-codiepie' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-connectdevelop' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-contao' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-css3' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-dashcube' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-delicious' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-deviantart' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-digg' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-dribbble' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-dropbox' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-drupal' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-edge' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-empire' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-envira' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-expeditedssl' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-fa' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-facebook' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-facebook-f' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-facebook-official' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-facebook-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-firefox' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-first-order' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-flickr' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-font-awesome' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-fonticons' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-fort-awesome' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-forumbee' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-foursquare' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-ge' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-get-pocket' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-git' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-git-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-github' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-github-alt' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-github-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-gitlab' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-gittip' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-glide' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-glide-g' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-google' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-google-plus' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-google-plus-circle' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-google-plus-official' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-google-plus-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-gratipay' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-hacker-news' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-houzz' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-html5' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-instagram' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-internet-explorer' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-ioxhost' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-joomla' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-jsfiddle' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-lastfm' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-lastfm-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-leanpub' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-linkedin' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-linkedin-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-linux' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-maxcdn' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-meanpath' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-medium' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-mixcloud' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-modx' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-odnoklassniki' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-odnoklassniki-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-opencart' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-openid' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-opera' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-optin-monster' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pagelines' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pied-piper' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pied-piper-alt' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pied-piper-pp' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pinterest' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pinterest-p' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-pinterest-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-product-hunt' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-qq' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-ra' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-rebel' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-reddit' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-reddit-alien' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-reddit-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-renren' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-resistance' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-safari' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-scribd' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-sellsy' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-shirtsinbulk' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-simplybuilt' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-skyatlas' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-skype' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-slack' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-slideshare' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-snapchat' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-snapchat-ghost' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-snapchat-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-soundcloud' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-spotify' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-stack-exchange' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-stack-overflow' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-steam' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-steam-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-stumbleupon' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-stumbleupon-circle' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-tencent-weibo' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-themeisle' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-trello' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-tripadvisor' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-tumblr' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-tumblr-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-twitch' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-twitter' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-twitter-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-usb' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-viacoin' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-viadeo' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-viadeo-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-vimeo' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-vimeo-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-vine' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-vk' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-wechat' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-weibo' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-weixin' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-whatsapp' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-wikipedia-w' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-windows' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-wordpress' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-wpbeginner' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-wpforms' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-xing' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-xing-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-y-combinator' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-y-combinator-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-yahoo' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-yc' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-yc-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-yelp' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-yoast' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-youtube' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-youtube-square' => array( 'group' => 'brand','group_id' =>'awesome'),
					'fa fa-h-square' => array( 'group' => 'medical','group_id' =>'awesome'),
					'fa fa-hospital-o' => array( 'group' => 'medical','group_id' =>'awesome'),
					'fa fa-medkit' => array( 'group' => 'medical','group_id' =>'awesome'),
					'fa fa-stethoscope' => array( 'group' => 'medical','group_id' =>'awesome'),
					'fa fa-user-md' => array( 'group' => 'medical','group_id' =>'awesome'),
				),
			),
			
		);
		$icon_config = slz()->theme->get_config('supported_flaticon');
		
		if( !empty($icon_config['is_supported']) && !empty($icon_config['slz_icon_map'])) {
			// flaticon - 'flaticon-animals' => array('group_id' => 'flaticon')
			$icon_settings['font-awesome']['font-style-src'][] = $icon_config['url'];
			$icon_settings['font-awesome']['font-type']['flaticon'] =__('Font Flaticon', 'slz');
			$icon_settings['font-awesome']['icons'] = array_merge($icon_settings['font-awesome']['icons'], $icon_config['slz_icon_map']);
		}
		return $icon_settings;
	}
}
SLZ_Option_Type::register('SLZ_Option_Type_Icon');
