<?php

$shortcode = slz_ext( 'shortcodes' )->get_shortcode( 'posts_carousel' );

$params = array(
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Layout', 'holycross' ),
		'param_name'  => 'template',
		'value'       => $shortcode->get_styles(),
		'std'		  => 1,
		'description' => esc_html__( 'Choose a layout to show.', 'holycross' ),
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Column', 'holycross' ),
		'param_name'  => 'column',
		'value'       => array(
			esc_html__('One Column', 'holycross') 			=>	1,
			esc_html__('Two Column', 'holycross')			=>	2,
			esc_html__('Three Column', 'holycross')			=>	3,
			esc_html__('Four Column', 'holycross')			=>	4
		),
		'std'		  => 1,
		'description' => esc_html__( 'Choose a column for display block.', 'holycross' ),
		'dependency' => array(
			'element' => 'template',
			'value'   => '1'
		)
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Style', 'holycross' ),
		'param_name'  => 'style',
		'value'       => array(
			esc_html__('Florida', 'holycross') 			=>	1,
			esc_html__('California', 'holycross')		=>	2
		),
		'std'		  => 1,
		'description' => esc_html__( 'Choose a column for display block.', 'holycross' ),
		'dependency' => array(
			'element' => 'template',
			'value'   => '1'
		)
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Block Title', 'holycross' ),
		'param_name'  => 'block_title',
		'value'       => '',
		'description' => esc_html__( 'Block title. If it blank the block will not have a title', 'holycross' )
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Block Title Color', 'holycross' ),
		'param_name'  => 'block_title_color',
		'value'       => '',
		'description' => esc_html__( 'Choose a custom title text color.', 'holycross' )
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Excerpt', 'holycross' ),
		'param_name'  => 'excerpt',
		'value'       => array(
			esc_html__('Show', 'holycross')	=>	'show',
			esc_html__('Hide', 'holycross')	=>	'hide'
		),
		'std'         => 'show',
		'description' => esc_html__( 'Show or hide post excerpt', 'holycross' )
	),
    array(
        'type'        => 'textfield',
        'heading'     => esc_html__( 'Excerpt Length', 'holycross' ),
        'param_name'  => 'excerpt_length',
        'value'       => '30',
        'description' => esc_html__( 'Input number of excerpt length.', 'holycross' ),
        'dependency'  => array(
            'element'   => 'excerpt',
            'value'     => array('show')
        )
    ),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Readmore Button', 'holycross' ),
		'param_name'  => 'readmore',
		'value'       => array(
			esc_html__('Show', 'holycross')	=>	'show',
			esc_html__('Hide', 'holycross')	=>	'hide'
		),
		'std'         => 'show',
		'description' => esc_html__( 'Show or hide readmore button', 'holycross' )
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Number Posts', 'holycross' ),
		'param_name'  => 'limit_post',
		'value'       => '5',
		'description' => esc_html__( 'The number of posts to display. If it blank the number posts will be the number from Settings -> Reading', 'holycross' )
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Offset Posts', 'holycross' ),
		'param_name'  => 'offset_post',
		'value'       => '',
		'description' => esc_html__( 'Enter offset to display. If you want to start on record 6, using offset 5', 'holycross' )
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Sort By', 'holycross' ),
		'param_name'  => 'sort_by',
		'value'       => slz()->backend->get_param('sort_blog'),
		'description' => esc_html__( 'Choose criteria to display.', 'holycross' )
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Extra Class', 'holycross' ),
		'param_name'  => 'extra_class',
		'value'       => '',
		'description' => esc_html__( 'Add extra class to block', 'holycross' )
	)
);

$yes_no  = array(
	esc_html__('Yes', 'holycross')		=> 'yes',
	esc_html__('No', 'holycross')			=> 'no'
);
$animation  = array(
	esc_html__('Slide', 'holycross')		=> '0',
	esc_html__('Fade', 'holycross')		=> '1'
);
$custom_slide = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Dots ?', 'holycross' ),
		'param_name'  	=> 'show_dots',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show dots.', 'holycross' ),
		'group'         => esc_html__('Slide Custom', 'holycross')
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Arrow ?', 'holycross' ),
		'param_name'  	=> 'show_arrows',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show arrow.', 'holycross' ),
		'group'         => esc_html__('Slide Custom', 'holycross')
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Auto Play ?', 'holycross' ),
		'param_name'  	=> 'slide_autoplay',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to slide auto play.', 'holycross' ),
		'group'         => esc_html__('Slide Custom', 'holycross')
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Loop Infinite ?', 'holycross' ),
		'param_name'  	=> 'slide_infinite',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to slide loop infinite.', 'holycross' ),
		'group'         => esc_html__('Slide Custom', 'holycross')
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Speed Slide', 'holycross' ),
		'param_name'    => 'slide_speed',
		'value'			=> '',
		'description'   => esc_html__( 'Enter number value. Unit is millisecond. Example: 600.', 'holycross' ),
		'group'         => esc_html__('Slide Custom', 'holycross')
	),
	array(
		'type'          => 'dropdown',
		'heading'       => esc_html__( 'Animation?', 'holycross' ),
		'param_name'    => 'animation',
		'value'			=> $animation,
		'description'   => esc_html__( 'Choose a animation', 'holycross' ),
		'group'         => esc_html__('Slide Custom', 'holycross')
	)
);

$vc_options = array_merge( 
	$params,
	slz()->backend->get_param('shortcode_filter'),
	slz()->backend->get_param('shortcode_ajax_filter'),
	$custom_slide
);
