<?php
$out = $icon_class = $has_background = $custom_css = $css = '';

$i = 1;

$shortcode = slz_ext( 'shortcodes' )->get_shortcode('icons_block');

$data['align'] = !empty($data['align']) ? $data['align']: 'text-l';

$param_default  = array(
	'block_bg_cl'              => '',
	'block_bg_hv_cl'           => '',
	'icon_type'                => '',
	'block_bg_img'             => '',
	'block_bg_hv_img'          => '',
	'img_up'                   => '',
	'title'                    => '',
	'des'                      => '',
);

switch ( $data['layout-1-style'] ) {

	case 'st-california':
		$icon_class = 'icon-background icon-circle';
		break;
	case 'st-georgia':
		$icon_class = 'icon-background icon-square';
		break;
	default:
		break;
}

if ( !empty( $data['icon_box'] ) ) {
	$items = (array) vc_param_group_parse_atts( $data['icon_box'] );
	$out .= '<div class="slz-list-icon-block '. esc_attr( $data['column'] ) .' '.esc_attr($data['spacing_style']).' ">';
		foreach ( $items as $item ) {

			//--------------------- custom css-------------------//
			
				// background color
				if(!empty($item['block_bg_cl'])){
					$has_background = "has-bg";
					$css = '
							.%1$s .item-%2$s .slz-icon-block{
								background-color: %3$s;
							}
						';
					$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr($i), esc_attr( $item['block_bg_cl']) );

				}

				// hover background color
				if(!empty($item['block_bg_hv_cl'])){
					$has_background = "has-bg-hover";
					$css = '
							.%1$s .item-%2$s .slz-icon-block.has-bg-hover .bg-icon-block {
								background-color: %3$s;
							}
						';
					$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr($i), esc_attr( $item['block_bg_hv_cl']) );
				}

				// background image
				if(!empty($item['block_bg_img'])) {
					$has_background = "has-bg";
					$img_url = wp_get_attachment_url( $item['block_bg_img'] );
					$css = '
						.%1$s .item-%2$s .slz-icon-block{
							background-image: url("%3$s");
						}
					';
					$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr($i), esc_attr($img_url) );
				}

				// hover background image
				if(!empty($item['block_bg_hv_img'])) {
					$has_background = "has-bg-hover bg-img-hover";
					$img_url = wp_get_attachment_url( $item['block_bg_hv_img'] );
					$css = '
						.%1$s .item-%2$s .slz-icon-block.has-bg-hover .bg-icon-block {
							background-image: url("%3$s");
						}
					';
					$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr($i), esc_attr($img_url) );
				}

			//---------------content html----------------------//

			$item = array_merge( $param_default, $item );
		
			$out .= '<div class="item item-'.esc_attr($i).' '.$data['item_animation'] .' wow" data-wow-delay="' . $data['delay_animation'] . '">';

				$out .='<div class="slz-icon-block  '.esc_attr($has_background).' '.esc_attr($data['align']).'">';

					// ----------- icon --------//
					$out .= '<div class="icon-cell '.esc_attr($icon_class).'">';
						if ( $item['icon_type'] == '02' ) {
							if ( !empty( $item['img_up'] ) && $img_url = wp_get_attachment_url( $item['img_up'] ) ) {
								$out .= '
									<div class="wrapper-icon-image">
										<img src="'.esc_url( $img_url ).'" alt="" class="slz-icon-img">
									</div>
								';
							}
						}else{
							$format = '<div class="wrapper-icon"><i class="slz-icon %1$s"></i></div>';
							$out .= $shortcode->get_icon_library_views( $item, $format );
						}
					$out .= '</div>';

					//----------- content --------//
					$out .= '<div class="content-cell">';
						$out .= '<div class="wrapper-info">';
							// title
							if( !empty($item['title']) ){

								$out .= '<div class="title '.esc_attr($data['title_line']).'">'.esc_attr( $item['title'] ).'</div>';
							}
							// description
							if( !empty($item['des'])){
								$out .= '<div class="description">'.wp_kses_post( nl2br ($item['des'] ) ).'</div>';
							}
							
						$out .= '</div>';
					$out .= '</div>';

					//----------- background hover --------//
					$out .= '<div class="bg-icon-block direction-hover"></div>';

				$out .= '</div>';
				
			$out .= '</div>';

			$i++;

		}//end foreach

	$out .= '</div>';

}

//printf data
echo wp_kses_post($out);


//-------custom general css------------//

	
	// icon background color
	if( !empty( $data['icon_bg_cl_1'] ) ){
		$css = '
				.%1$s .icon-background.wrapper-icon {
					background-color: %2$s;
				}
			';
		$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr( $data['icon_bg_cl_1']) );
	}

	// icon background hover color
	if( !empty( $data['icon_bg_hv_cl_1'] ) ){
		$css = '
				.%1$s .icon-background .wrapper-icon:hover{
					background-color: %2$s;
				}
			';
		$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr( $data['icon_bg_hv_cl_1']) );
	}

	// icon background color
	if( !empty( $data['icon_bd_cl_1'] ) ){
		$css = '
				.%1$s .icon-background .wrapper-icon {
					border-color: %2$s;
				}
			';
		$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr( $data['icon_bd_cl_1']) );
	}

	// icon background hover color
	if( !empty( $data['icon_bd_hv_cl_1'] ) ){
		$css = '
				.%1$s .icon-background .wrapper-icon:hover{
					boder-color: %2$s;
				}
			';
		$custom_css .= sprintf( $css, esc_attr( $data['uniq_id'] ), esc_attr( $data['icon_bd_hv_cl_1']) );
	}

	if ( !empty( $custom_css ) ) {
		do_action('slz_add_inline_style', $custom_css);
	}