<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Forbidden' ); }

if ( ! is_plugin_active( 'js_composer/js_composer.php' ) ) {
	echo esc_html__('Please Active Visual Composer', 'slz');
	return;
}

$model = new SLZ_Service();
$model->init( $data );

// no data
if( ! $model->query->have_posts() ) return;

$uniq_id = $model->attributes['uniq_id'];

$block_class[] = $uniq_id;

$cfg_layout_class = $instance->get_config('layouts_class');

if( isset($cfg_layout_class[$data['layout']]) ) {
	$block_class[] = $cfg_layout_class[$data['layout']];
}
$block_class[] = $model->attributes['extra_class'];

$model->attributes['block_class'] = implode(' ', $block_class );
$data = $model->attributes;

if( !empty($data['bg_image']) && $data['bg_image'] == 'yes' ) {
	$model->attributes['show_thumbnail'] = $data['bg_image'];
} else {
	$data['bg_image'] = '';
}
$data['full_image'] = '';
if( $model->attributes['show_icon'] == 'feature-image'){
	$data['full_image'] = 'f-image-full';
}
$data['openRow'] = $data['closeRow'] = '';
if( isset($data['show_slider']) && $data['show_slider'] == 'yes') {
	if( empty($data['slide_to_show']) ) {
		$data['slide_to_show'] = 3;
	}
	$data['column'] = $data['slide_to_show'];
	$data['openRow'] = '
		<div class="slz-carousel-wrapper">
			<div class="slz-carousel slz-service-slide-slick"
				data-slidestoshow="'.esc_attr( $data['slide_to_show'] ).'"
				data-arrowshow="'.esc_attr( $data['slide_arrows'] ).'"
				data-dotshow="'.esc_attr( $data['slide_dots'] ).'"
				data-autoplay="'.esc_attr( $data['slide_autoplay'] ).'"
				data-infinite="'.esc_attr( $data['slide_infinite'] ).'"
				data-slidespeed="'.esc_attr( $data['slide_speed'] ).'"
				>';
	$data['closeRow'] = '</div></div>';
	$data['column_class'] = '';
	$model->attributes['pagination'] = 'no';
} else {
	$column = 'slz-column-' . (!empty($model->attributes['column']) ? $model->attributes['column'] : '3' );
	$data['openRow'] = '<div class="slz-list-icon-block '. esc_attr($column) .' ' .esc_attr($data['spacing_style']) .'">';
	$data['closeRow'] = '</div>';
	$data['show_slider'] = '';
}

$params = array( 'model'=> $model, 'data' => $data );
echo '<div class="slz_shortcode sc_service_block '.esc_attr( $model->attributes['block_class'] ).'">';
	echo '<div class="'.esc_attr($data[ $data['layout'].'-style']).'">';
		switch ( $data['layout'] ) {
			case 'layout-1':
				echo slz_render_view( $instance->locate_path('/views/layout-1.php'), $params );
				break;
			case 'layout-2':
				echo slz_render_view( $instance->locate_path('/views/layout-2.php'), $params );
				break;
			case 'layout-3':
				echo slz_render_view( $instance->locate_path('/views/layout-3.php'), $params );
				break;
			case 'layout-4':
				echo slz_render_view( $instance->locate_path('/views/layout-4.php'), $params );
				break;
			default:
				echo slz_render_view( $instance->locate_path('/views/layout-1.php'), $params );
				break;
		}
	echo '</div>';
echo '</div>';