<?php
function slz_autoload_core_css() {
	$ext = slz_ext('autoload');
	$cfg_enables = $ext->get_config('enable_extension_css');
	$version = $ext->manifest->get_version();
	//
	foreach( $cfg_enables as $name ) {
		if( slz_ext($name) ) {
			$file = $ext->locate_URI('/static/css/'.$name.'.css');
			wp_enqueue_style(
					'slz-extension-autoload-' . $name,
					$file,
					array(),
					$version
			);
		}
	}
}
function slz_autoload_core_scripts() {
	$ext = slz_ext('autoload');
	$cfg_enables = $ext->get_config('enable_extension_js');
	$version = $ext->manifest->get_version();
	foreach( $cfg_enables as $name ) {
		if( slz_ext($name) ) {
			$file = $ext->locate_URI( '/static/js/'.$name.'.js');
			wp_enqueue_script(
					'slz-extension-autoload-' . $name,
					$file,
					array( 'jquery' ),
					$version,
					true
			);
		}
	}
}
function slz_autoload_core_shortcodes_css(){
	$autoload = slz_ext('autoload');
	$cfg_enables = $autoload->get_config('enable_shortcodes_css');
	$ext = slz_ext('shortcodes');
	$active_shorcodes = $ext->get_shortcodes();
	$version = $ext->manifest->get_version();
	foreach($cfg_enables as $name ){
		$shortcode = str_replace('-', '_', $name);
		if( isset($active_shorcodes[$shortcode]) ) {
			wp_enqueue_style(
					'slz-extension-shortcodes-' . $name,
					$autoload->locate_URI('/static/css/shortcodes/'.$name.'.css'),
					array(),
					$version
			);
		}
	}
}
function slz_autoload_core_extra_css(){
	$ext = slz_ext('autoload');
	$cfg_enables = $ext->get_config('extra_css');
	$version = $ext->manifest->get_version();
	foreach($cfg_enables as $name ){
		$file = $ext->locate_URI('/static/css/'.$name.'.css');
		wp_enqueue_style(
				'slz-extension-autoload-' . $name,
				$file,
				array(),
				$version
		);
	}
}
function slz_autoload_core_extra_js(){
	$ext = slz_ext('autoload');
	$cfg_enables = $ext->get_config('extra_js');
	$version = $ext->manifest->get_version();
	foreach($cfg_enables as $name ){
		$file = $ext->locate_URI('/static/css/'.$name.'.js');
		wp_enqueue_script(
			'slz-extension-autoload-' . $name,
			$file,
			array( 'jquery' ),
			$version,
			true
		);
	}
}